//
//  NSString+SymlinksAndAliases.h
//  ResolvePath
//
//  Created by Matt Gallagher on 2010/02/22.
//  Copyright 2010 Matt Gallagher. All rights reserved.
//
//  Permission is given to use this source code file, free of charge, in any
//  project, commercial or otherwise, entirely at your risk, with the condition
//  that any redistribution (in part or whole) of source code must retain
//  this copyright and permission notice. Attribution in compiled projects is
//  appreciated but not required.
//

#import <Cocoa/Cocoa.h>

@interface NSString (SymlinksAndAliases)

- (nullable NSString *)stringByResolvingSymlinksAndAliases;

- (nullable NSString *)stringByIterativelyResolvingSymlinkOrAlias;

- (nullable NSString *)stringByResolvingSymlink;

- (nullable NSString *)stringByConditionallyResolvingSymlink;

- (nullable NSString *)stringByResolvingAlias;

- (nullable NSString *)stringByConditionallyResolvingAlias;

- (nullable NSString *)URLStringByAppendingQueryString:(nonnull NSString *)queryString;

@end

@interface NSURL (SymlinksAndAliases)

- (nullable NSURL *)URLByResolvingSymlinksAndAliases;

@end
